/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.skills.GenShinInternal;

import com.dfdyz.epicacg.registry.MySkillDataKeys;
import com.dfdyz.epicacg.registry.MySkills;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GSBasicAtkPatch
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("10f7b428-63f8-4867-2615-9bf8edbecd97");

    public GSBasicAtkPatch(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!event.getAnimation().isBasicAttackAnimation()) {
                container.getDataManager().setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)0);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_5833_() && playerState.canBasicAttack();
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (!executer.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (PlayerEvent)new BasicAttackEvent(executer))) {
            if (MySkills.GS_Bow_FallAttackPatch.isExecutableState((PlayerPatch)executer)) {
                MySkills.GS_Bow_FallAttackPatch.executeOnServer(executer, args);
                return;
            }
            CapabilityItem cap = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            StaticAnimation attackMotion = null;
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            SkillDataManager dataManager = executer.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager();
            int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get());
            if (player.m_20159_()) {
                Entity entity = player.m_20202_();
                if (entity instanceof PlayerRideableJumping && ((PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                    attackMotion = ((AnimationProvider)cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size())).get();
                    ++comboCounter;
                }
            } else {
                boolean fallAttack;
                List combo = cap.getAutoAttckMotion((PlayerPatch)executer);
                int comboSize = combo.size();
                boolean dashAttack = player.m_20142_();
                boolean bl = fallAttack = player.m_20184_().f_82480_ <= -0.3;
                if (fallAttack) {
                    Vec3 epos = ((ServerPlayer)executer.getOriginal()).m_20182_();
                    ClipContext clipContext = new ClipContext(epos, epos.m_82520_(0.0, -3.6, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, executer.getOriginal());
                    Level level = ((ServerPlayer)executer.getOriginal()).m_9236_();
                    BlockHitResult result = level.m_45547_(clipContext);
                    boolean bl2 = fallAttack = result.m_6662_() == HitResult.Type.MISS || result.m_6662_() == HitResult.Type.ENTITY;
                }
                comboCounter = dashAttack ? comboSize - 2 : (fallAttack ? comboSize - 1 : (comboCounter %= comboSize - 2));
                attackMotion = ((AnimationProvider)combo.get(comboCounter)).get();
                comboCounter = dashAttack || fallAttack ? 0 : comboCounter + 1;
            }
            dataManager.setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)comboCounter);
            if (attackMotion != null) {
                executer.playAnimationSynchronized(attackMotion, 0.0f);
            }
            executer.updateEntityState();
        }
    }

    public void updateContainer(SkillContainer container) {
        if (container.getExecuter().getTickSinceLastAction() > 50 && (Integer)container.getDataManager().getDataValue((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get()) > 0) {
            container.getDataManager().setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)0);
        }
    }
}

